<?php // 00 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/
#header {
  transition: all 0.5s;
  z-index: 997;
  padding: 20px 0;
}

#header.header-scrolled, #header.header-inner-pages {
  background: rgba(17, 17, 17);
  padding: 12px 0;
}

#header .logo {
  font-size: 42px;
  margin: 0;
  padding: 0;
  line-height: 0.7;
  font-weight: 600;
  letter-spacing: 2px;
  text-transform: uppercase;
  font-family: 'Philosopher', sans-serif;
}

#header .logo a {
  color: #fff;
}

#header .logo img {
  max-height: 40px;
}

@media (max-width: 992px) {
  #header {
    padding: 12px 0;
  }
  #header .logo {
    /*font-size: 28px;*/
    font-size: 36px;
  }
}

/*--------------------------------------------------------------
# Navigation Menu
--------------------------------------------------------------*/
/* Desktop Navigation */
.nav-menu ul {
	margin: 0;
	padding: 0;
	list-style: none;
}

.nav-menu > ul {
	display: flex;
}

.nav-menu > ul > li {
	position: relative;
	white-space: nowrap;
	padding: 10px 0 10px 24px;
}

.nav-menu a {
	display: block;
	position: relative;
	color: rgba(255, 255, 255, 0.7);
	transition: 0.3s;
	font-size: 13px;
	font-weight: 600;
	padding: 0 3px;
	font-family: Arial, Helvetica, sans-serif;
	text-transform: uppercase;
}

.nav-menu > ul > li > a:before {
	content: "";
	position: absolute;
	width: 100%;
	height: 2px;
	bottom: -5px;
	left: 0;
	background-color: #fff;
	visibility: hidden;
	width: 0px;
	transition: all 0.3s ease-in-out 0s;
}

.nav-menu a:hover:before, .nav-menu li:hover > a:before, .nav-menu .active > a:before {
	visibility: visible;
	width: 100%;
}

.nav-menu a:hover, .nav-menu .active > a, .nav-menu li:hover > a {
	color: #fff;
}

.nav-menu .drop-down ul {
	display: block;
	position: absolute;
	left: 22px;
	top: calc(100% + 30px);
	z-index: 99;
	opacity: 0;
	visibility: hidden;
	padding: 10px 0;
	background: #fff;
	box-shadow: 0px 0px 30px rgba(127, 137, 161, 0.25);
	transition: 0.3s;
}

.nav-menu .drop-down:hover > ul {
	opacity: 1;
	top: 100%;
	visibility: visible;
	border-top: 3px solid rgba(27,189,54);
}

.nav-menu .drop-down li {
	min-width: 180px;
	position: relative;
}

.nav-menu .drop-down ul a {
	padding: 10px 20px;
	font-size: 13px;
	text-transform: none;
	color: rgba(0,0,0);
	text-transform: uppercase;
}

.nav-menu .drop-down ul a:hover, .nav-menu .drop-down ul .active > a, .nav-menu .drop-down ul li:hover > a {
	color: rgba(27,189,54);
}

.nav-menu .drop-down > a:after {
  content: "\ea99";
  font-family: IcoFont;
  padding-left: 5px;
}

.nav-menu .drop-down .drop-down ul {
  top: 0;
  left: calc(100% - 30px);
}

.nav-menu .drop-down .drop-down:hover > ul {
  opacity: 1;
  top: 0;
  left: 100%;
}

.nav-menu .drop-down .drop-down > a {
  padding-right: 35px;
}

.nav-menu .drop-down .drop-down > a:after {
  content: "\eaa0";
  font-family: IcoFont;
  position: absolute;
  right: 15px;
}

@media (max-width: 1366px) {
  .nav-menu .drop-down .drop-down ul {
    left: -90%;
  }
  .nav-menu .drop-down .drop-down:hover > ul {
    left: -100%;
  }
  .nav-menu .drop-down .drop-down > a:after {
    content: "\ea9d";
  }
}

/* Get Startet Button */
.get-started-btn {
  margin-left: 25px;
  color: #fff;
  border-radius: 5px;
  padding: 6px 25px 8px 25px;
  white-space: nowrap;
  transition: 0.3s;
  font-size: 14px;
  font-weight: 600;
  display: inline-block;
  border: 2px solid rgba(255, 255, 255, 0.5);
}

.get-started-btn:hover {
  border-color: #fff;
  color: #fff;
}

@media (max-width: 992px) {
  .get-started-btn {
    margin: 0 48px 0 0;
    padding: 6px 18px;
  }
}

/* Mobile Navigation */
.mobile-nav-toggle {
  position: fixed;
  right: 15px;
  top: 30px;
  z-index: 9998;
  border: 0;
  background: none;
  font-size: 24px;
  transition: all 0.4s;
  outline: none !important;
  line-height: 1;
  cursor: pointer;
  text-align: right;
}

.mobile-nav-toggle i {
	color: #fff;
}

.mobile-nav {
  position: fixed;
  top: 55px;
  right: 15px;
  bottom: 15px;
  left: 15px;
  z-index: 9999;
  overflow-y: auto;
  background: #fff;
  transition: ease-in-out 0.2s;
  opacity: 0;
  visibility: hidden;
  border-radius: 10px;
  padding: 10px 0;
}

.mobile-nav * {
  margin: 0;
  padding: 0;
  list-style: none;
}

.mobile-nav a {
  display: block;
  position: relative;
  color: #2c4964;
  padding: 10px 20px;
  font-weight: 500;
  outline: none;
}

.mobile-nav a:hover, .mobile-nav .active > a, .mobile-nav li:hover > a {
  color: rgba(27,189,54);
  text-decoration: none;
}

.mobile-nav .drop-down > a:after {
  content: "\ea99";
  font-family: IcoFont;
  padding-left: 10px;
  position: absolute;
  right: 15px;
}

.mobile-nav .active.drop-down > a:after {
  content: "\eaa1";
}

.mobile-nav .drop-down > a {
  padding-right: 35px;
}

.mobile-nav .drop-down ul {
  display: none;
  overflow: hidden;
}

.mobile-nav .drop-down li {
  padding-left: 20px;
}

.mobile-nav-overly {
  width: 100%;
  height: 100%;
  z-index: 9997;
  top: 0;
  left: 0;
  position: fixed;
  background: rgba(28, 47, 65, 0.6);
  overflow: hidden;
  display: none;
  transition: ease-in-out 0.2s;
}

.mobile-nav-active {
  overflow: hidden;
}

.mobile-nav-active .mobile-nav {
  opacity: 1;
  visibility: visible;
}

.mobile-nav-active .mobile-nav-toggle i {
  color: #fff;
}

/*--------------------------------------------------------------
# Hero Section
--------------------------------------------------------------*/
#hero {
  width: 100%;
  height: 100vh;
  background: linear-gradient(45deg, rgba(30, 30, 30, 0.9) 0%, rgba(30, 30, 30, 0.9) 100%), url("images/earth-wallpapers-20.jpg") center center no-repeat;
  background-size: cover;
}

#hero .container, #hero .container-fluid {
  padding-top: 84px;
}

#hero h1 {
  margin: 0;
  font-size: 52px;
  font-weight: 700;
  line-height: 64px;
  color: #fff;
}

#hero h2 {
  color: rgba(255, 255, 255, 0.8);
  margin: 10px 0 0 0;
  font-size: 20px;
}

#hero .btn-get-started {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  margin-top: 30px;
  color: #fff;
  border: 2px solid rgba(27,189,54);
}

#hero .btn-get-started:hover {
  background: rgba(27,189,54);
  color: #fff;
}

#hero .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}

@media (min-width: 1200px) {
  #hero {
    background-attachment: fixed;
  }
}

@media (max-width: 991px) {
  #hero {
    text-align: center;
  }
  #hero .container, #hero .container-fluid {
    padding-top: 68px;
  }
  #hero .animated {
    -webkit-animation: none;
    animation: none;
  }
  #hero .hero-img {
    text-align: center;
  }
  #hero .hero-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  #hero h1 {
    font-size: 26px;
    line-height: 36px;
  }
  #hero h2 {
    font-size: 18px;
    line-height: 24px;
  }
  #hero .hero-img img {
    width: 60%;
  }
}

@media (max-width: 575px) {
  #hero .hero-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

/*--------------------------------------------------------------
# Sections General
--------------------------------------------------------------*/
section {
  padding: 100px 0;
  overflow: hidden;
}

.section-bg {
  background-color: #f9f8ff;
}

.section-title {
  text-align: center;
  padding-bottom: 30px;
}

.section-title h2 {
  font-size: 32px;
  font-weight: bold;
  text-transform: uppercase;
  margin-bottom: 20px;
  padding-bottom: 20px;
  position: relative;
}

.section-title h2::after {
  content: '';
  position: absolute;
  display: block;
  width: 50px;
  height: 3px;
  background: rgba(27,189,54);
  bottom: 0;
  left: calc(50% - 25px);
}

.section-title p {
  margin-bottom: 0;
}
 
</style>
</head>
<body>	
<div>
<header id="header" class="fixed-top ">
    <div class="container-fluid">

		<div class="row justify-content-center">
			<div class="col-xl-10 d-flex align-items-center">
				<h1 class="logo mr-auto"><a href="index.php">Space <br/><span style="font-size: 17px;color: rgba(27,189,54);border-top: 2px solid #fff;padding-top: 3px;">Global Services</span></a></h1>
				<!-- Uncomment below if you prefer to use an image logo -->
				<!-- <a href="index.html" class="logo mr-auto"><img src="assets/img/logo.png" alt="" class="img-fluid"></a>-->

				<nav class="nav-menu d-none d-lg-block">
					<ul>
						<li class="active"><a href="index.php">Home</a></li>
						<!--li class="drop-down"><a href="">VoIP</a>
							<ul>
								<li><a href="voip.php">What Is VoIP</a></li>
								<li><a href="voip.php">How Does VoIP Works</a></li>
								<li><a href="voip.php">What Are VoIP Codecs</a></li>
								<li><a href="voip.php">What Is VoIP Business</a></li>
								<li><a href="voip.php">How To Connect With VoIP To Network</a></li>
							</ul>
						</li-->
						<!--li class="drop-down"><a href="">Sip</a>
							<ul>
								<li><a href="sip.php">What Is Sip (Session Initiation Protocol)</a></li>
								<li><a href="sip.php">How Does Sip Works</a></li>
								<li><a href="sip.php">What is the role of a SIP registrar</a></li>
								<li><a href="sip.php">Does SIP use TCP or UDP</a></li>
							</ul>
						</li-->   
						
					
					
						<!--li class="drop-down"><a href="">Drop Down</a>
							<ul>
								<li><a href="#">Drop Down 1</a></li>
								<li class="drop-down"><a href="#">Deep Drop Down</a>
									<ul>
										<li><a href="#">Deep Drop Down 1</a></li>
										<li><a href="#">Deep Drop Down 2</a></li>
										<li><a href="#">Deep Drop Down 3</a></li>
										<li><a href="#">Deep Drop Down 4</a></li>
										<li><a href="#">Deep Drop Down 5</a></li>
									</ul>
								</li>
								<li><a href="#">Drop Down 2</a></li>
								<li><a href="#">Drop Down 3</a></li>
								<li><a href="#">Drop Down 4</a></li>
							</ul>
						</li-->
						
						<!--li><a href="vps.php">VPS</a></li>
						<li><a href="vos.php">VOS</a></li>
						<li><a href="sippy.php">Sippy</a></li-->
						
						
						<li><a href="digital_marketing.php">Digital Marketing</a></li>
						<li><a href="seo.php">SEO</a></li>
						
						<li class="drop-down"><a href="">Development</a>
							<ul>
								<li><a href="website_development.php">Website Development</a></li>
								<li><a href="software_development.php">Software Development</a></li>
							</ul>
						</li>
						
						<li class="drop-down"><a href="">Call Types</a>
							<ul>
								<li class="drop-down"><a href="#">Call Traffic Types</a>
									<ul>
										<li><a href="call_types.php">Cli Route</a></li>
										<li><a href="call_types.php">Non-Cli Route</a></li>
										<li><a href="call_types.php">Direct Routes</a></li>
										<li><a href="call_types.php">TDM</a></li>
										<li><a href="call_types.php">PRI</a></li>
									</ul>
								</li>
								<li class="drop-down"><a href="#">Traffic Profile</a>
									<ul>
										<li><a href="call_types.php">Outbound Calls</a></li>
										<li><a href="call_types.php">Press 1 Calls</a></li>
									</ul>
								</li>
							</ul>
						</li>
						
						<li class="drop-down"><a href="">Services</a>
							<ul>
								<li><a href="vps.php">VPS</a></li>
								<li><a href="vos.php">VOS</a></li>
								<li><a href="sippy.php">Sippy</a></li>
								<li><a href="pbx.php">PBX</a></li>
								<li><a href="asterisk.php">Asterisk</a></li>
								
								<li class="drop-down"><a href="#">VICIDial</a>
									<ul>
										<li><a href="vicidial.php">What Is VICIDial</a></li>
										<li><a href="vicidial.php">How Does VICIDial Works</a></li>
										<li><a href="vicidial.php">VICIDial Minimum Hardware</a></li>
										<li><a href="vicidial.php">VICIDial Installation</a></li>
									</ul>
								</li>
							</ul>
						</li> 
						
						
						<li><a href="contact_us.php">Contact</a></li>
						<!--li><a href="about_us.php">About</a></li-->
						<!--li><a href="#services">Services</a></li>
						<li><a href="#portfolio">Portfolio</a></li>
						<li><a href="#team">Team</a></li-->
					</ul>
				</nav><!-- .nav-menu -->

				
			</div>
		</div>

	</div>
</header><!-- End Header -->
<!-- ======= Hero Section ======= -->
<section id="hero" class="d-flex align-items-center">
    <div class="container-fluid" data-aos="fade-up">
		<div class="row justify-content-center">
			<div class="col-xl-5 col-lg-6 pt-3 pt-lg-0 order-2 order-lg-1 d-flex flex-column justify-content-center">
				<h1 class="name-ok">Better Server Experience With</h1>
				<h1><small>Space <span style="color: rgba(27,189,54);">Global Services</span></small></h1>
				<!--h2>We Are Team Of Talented Workers Making Server With Pulse Talk Global.</h2-->
				<h2>We Are Team Of Talented Workers Provide Best Services With Space Global Services.</h2>
				<div><a href="contact_us.php" class="btn-get-started scrollto">Get Started</a></div>
			</div>
			<div class="col-xl-4 col-lg-6 order-1 order-lg-2 hero-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/telzio-frontpage-hero-compressed.png" class="img-fluid animated" alt="" />
			</div>
		</div>
    </div>
</section><!-- End Hero -->
</body>
</html>