<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices VICIDial</title>
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "VICIDial"; 
}

#hero img {
	visibility: hidden;
	position: relative;
}
#hero img {
	visibility: visible;
	content: url(images/VOIP-TOP.png); 
}
/*--------------------------------------------------------------
# vicidial
--------------------------------------------------------------*/
.vicidial {
	padding: 120px 0px;
}

.vicidial .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.vicidial .content ul {
  list-style: none;
  padding: 0;
}

.vicidial .content ul li {
  padding-bottom: 10px;
}

.vicidial .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.vicidial .content p:last-child {
  margin-bottom: 0;
}

.vicidial .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.vicidial .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.vicidial .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#vicidial .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #vicidial .animated {
    -webkit-animation: none;
    animation: none;
  }
  #vicidial .vicidial-img {
    text-align: center;
  }
  #vicidial .vicidial-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #vicidial .vicidial-img img {
	 width: 60%;
  }
  #vicidial .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #vicidial .vicidial-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body onload="mypre()">	

<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">
<!-- ======= vicidial Section ======= -->
<section id="vicidial" class="vicidial">
    <div class="container">
	
		<a id="whatisvicidial"></a>
		<div class="section-title">
          <h2>VICIDial</h2>
          <p>VICIdial is an open source, Enterprise-level Contact Center solution.</p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 vicidial-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/PABX-IP-3CX-558x410-1.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What Is VICIDial?</h3>
				<p class="font-italic">
					VICIdial is an open source, Enterprise-level Contact Center solution being used by thousands of companies in over 100 countries around the world and it has no per-user license fees and is completely free for anyone to use. VICIdial allows agents to handle blended inbound and outbound calls as well as predictive and manual outbound list dialing and can also handle inbound emails and website customer chat sessions all within the same agent screen. The panel is accessible in 16 unique dialects.
					<br/>
					You can optically discern a minute list how organizations are utilizing VICIdial daily to get business done.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Customer service calls for small to medium size business</li>
					<li><i class="ri-check-double-line"></i> Hospital patients post-checkout survey</li>
					<li><i class="ri-check-double-line"></i> Broadcasting to members for an organization</li>
					<li><i class="ri-check-double-line"></i> Doctor’s office patient contact management: Incoming/Outgoing calls and email</li>
					<li><i class="ri-check-double-line"></i> Schools use broadcast messages and parent response IVRs</li>
					<li><i class="ri-check-double-line"></i> Emergency response call center which operates 24/7</li>
					<li><i class="ri-check-double-line"></i> Phone call logging and call redirection for lead management company (10,000+ Direct Inward Dialing)</li>
					<li><i class="ri-check-double-line"></i> Bank customer service call center</li>
				</ul>
				<a href="vicidial.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		<a id="vicidialworks"></a>
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 vicidial-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/callcenter.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>How Does VICIDial Works?</h3>
				<p class="font-italic">
					ViciDial Predictive dialer works by making an initial call and once the phone is connected to the customer, it will trigger an agent with "READY" status will make another call.<br/><br/>
					In which there will be 2 CONCURRENT CALLS, which resulted in extra cost for the company in telephone charges. Is this correct?.
				</p>
				<a href="vicidial.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		<a id="minimumhardware"></a>
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 vicidial-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/8562_1492249347_InternetServices2-1-2.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>VICIDial Minimum Hardware Specifications?</h3>
				<ul>
					<li><i class="ri-check-double-line"></i> Quad-Core CPU 2.0Ghz</li>
					<li><i class="ri-check-double-line"></i> 4GB RAM</li>
					<li><i class="ri-check-double-line"></i> 160 GB 7200rpm enterprise-grade SATA drive (Seagate ES, Hitachi UltraStar, WD RE4, etc)</li>
				</ul>
				<p class="font-italic">
					In addition to the above specifications, the following can be used for a more roubust server(Optional).
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> 8GB RAM (ECC if available)</li>
					<li><i class="ri-check-double-line"></i> Two hot-swap 500GB enterprise-grade SATA or SAS drives in RAID-1</li>
				</ul>
				<a href="vicidial.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		<a id="installation"></a>
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 vicidial-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/software-installation-maxpal.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>VICIDial Installation?</h3>
				<p class="font-italic">
					The standard ‘root’ password is ‘vicidial’ on all installation media. You can simply type ‘root’ at the Login prompt and ‘vicidial’ at the Password prompt.
					<br/><br/>
					ViciBox is available only in a 64-bit architecture. It is not available in a 32-bit architecture or for non-x86 predicated architectures like ARM or PowerPC. Any modern CPU relinquished after 2004 should not have any issues installing or running ViciBox.
					<br/><br/><b>Steps</b>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> 1. Download the ViciBox Server ISO from http://download.vicidial.com/iso/vicibox/server/</li>
					<li><i class="ri-check-double-line"></i> 2. Boot the ISO and the server will be booted to the First step of the installation. Using the arrow keys, highlight the ‘ViciBox v.X’ option in the center of the screen and press the ENTER key.</li>
					<li><i class="ri-check-double-line"></i> 3. At the license screen, press CTRL-A to agree to the license agreement.</li>
					<li><i class="ri-check-double-line"></i> 4. Then Press ALT-N to select ‘Next’ and proceed with the boot-up sequence.</li>
					<li><i class="ri-check-double-line"></i> 5. At the login prompt, type ‘root’ and password as’vicidial’. Then press ENTER.</li>
					<li><i class="ri-check-double-line"></i> 6. At the command prompt, type ‘os-install’ and press ENTER.</li>
					<li><i class="ri-check-double-line"></i> 7. You can change the default language,keyboard layout and Time zone.</li>
					<li><i class="ri-check-double-line"></i> 8. Type the new ‘root’ password that you would like to use.</li>
					<li><i class="ri-check-double-line"></i> 9. Press ALT-I to install the operating system according to the installation seettings you have selected.</li>
					<li><i class="ri-check-double-line"></i> 10. Press ALT-I to confirm the destruction of the host system’s old installation and installation of the new operating system.</li>
				</ul>
				<a href="vicidial.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		<?php include('public/ready_to_get_started.php');?> 
		
    </div>
</section><!-- End vicidial Section -->

</main><!-- End #main -->





<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>